#ifndef SST_SEP_ATP_BINDINGWRITINGPERMISSIONS_H
#define SST_SEP_ATP_BINDINGWRITINGPERMISSIONS_H
#include "SST_SEP_TST.h"
/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Apr 01 12:06:34 2009
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_SEP_BindingWritingPermissions.h#1:incl:1
   *  \author TaniaM
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************************ Structs  ******************************/
    typedef struct TST_ATP_BindingWritingPermissionsStruct{	
        DxChar                      TST_Name[TST_NAME_STRING_LEN];
        DxByte_t                    TST_Password[TST_PASSWORD_STRING_LEN];
        DxUint32_t                  TST_PasswordSizeInBytes;
        DxUint32_t                  TST_MaxNumOfTrials;
        DxByte_t                    TST_N[TST_N_SIZE_BYTES];
        DxUint32_t                  TST_NSizeInBytes;
        DxByte_t                    TST_D[TST_N_SIZE_BYTES];
        DxUint32_t                  TST_DSizeInBytes;
        DxByte_t                    TST_E[TST_E_SIZE_BYTES];
        DxUint32_t                  TST_ESizeInBytes;
        DxByte_t                    TST_ChallengeBuff[TST_CHALLENGE_SIZE_BYTES];
        DxUint32_t                  TST_ChallengeBuffSize; 
        DxByte_t                    TST_SignedChallengeBuff[TST_CHALLENGE_SIZE_BYTES];
        DxUint32_t                  TST_SignedChallengeBuffSize;
        DxByte_t                    TST_EncChallengeBuff[TST_CHALLENGE_SIZE_BYTES];
        DxByte_t                    TST_AesKey[TST_AES_KEY_SIZE];
        DxUint32_t                  TST_KeySizeInBytes;
        DxByte_t                    TST_Data[TST_MAX_DATA_VEC_SIZE_IN_BYTES];
        DxUint32_t                  TST_DataSize;
        DxUint32_t                  TST_DataReadOffset;
        DxByte_t                    TST_DataToWrite[TST_MAX_DATA_VEC_SIZE_IN_BYTES];
        DxUint32_t                  TST_DataToWriteSize;
        DxUint32_t                  TST_DataToWriteOffset;
        DxByte_t                    TST_ModifedData[TST_MAX_DATA_VEC_SIZE_IN_BYTES];
        DxByte_t                    TST_OutputData[TST_MAX_DATA_VEC_SIZE_IN_BYTES];
    } TST_ATP_BindingWritingPermissionsStruct;
/*****************************************************************************
* Function Name:
*  SEPQA_SST_BindingWritingPermissions
* 
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return
*
* Description:
* Test the bind and unbind authenticator to data object capabilities of the SST
* NOTE: this is a test that has error return values as a correct matter or operation!
*  
* Algorithm:
*    1.  Build a Private Key using CRYS for CRYS usage by calling: CRYS_RSA_Build_PrivKey (externally generated key).
*    2.  Create a new session  session#1 by calling: SST_SessionCreate.
*    3.  Create a new session  session#2 by calling: SST_SessionCreate.
*    4.  Create a new session  session#3 by calling: SST_SessionCreate.
*    5.  Open a transaction by calling: SST_TransactionStart.
*    6.  Create a new password authenticator by calling: SST_AuthenticatorPasswordCreate.
*    7.  Create a new asymmetric key authenticator by calling: SST_AuthenticatorPubKeyRSACreate. 
*    8.  Create a new asymmetric key authenticator by calling: SST_AuthenticatorAESSharedSecretCreate.
*    9.  Open the public key authenticator with session id#1 by calling:
*            i.   SST_AuthenticatorChallengeGet 
*            ii.  CRYS_RSA_PSS_Sign
*            iii. SST_AuthenticationOpen.
*    10. Close the transaction by calling: SST_TransactionClose.
*    11. Open a transaction by calling: SST_TransactionStart.
*    12. Open the AES shared key authenticator with session id#1 by calling:
*            i.   SST_AuthenticatorChallengeGet 
*            ii.  CRYS_AES (Encrypt the challenge using the AES key)
*            iii. SST_AuthenticationOpen.
*    13. Close the transaction by calling: SST_TransactionClose.
*    14. Open a transaction by calling: SST_TransactionStart.
*    15. Insert a new data object by calling: SST_InsertData with the Public key authenticator as master authenticator with session id#1.
*    16. Bind the password authenticator to the data object with read only permissions by calling: SST_BindAuthenticatorToElement using session id#1.
*    17. Bind the AES shared key authenticator to the data object with read/write permissions by calling: SST_BindAuthenticatorToElement using session id#1.
*    18. Close all the authenticators (one by one) by calling: SST_AuthenticationClose.
*    19. Close the transaction by calling: SST_TransactionClose.
*    20. Open the password authenticator by calling: SST_AuthenticationOpen. using session id#2
*    21. Open a transaction by calling: SST_TransactionStart.
*    22. Using session id#2 read and compare the data by calling: SST_ReadData. 
*    23. Using session id#2 try to modify the data by calling: SST_ModifyData. (This should fail!)
*    24. Try to bind the AES shared key authenticator to the data by calling: SST_BindAuthenticatorToElement. (This should fail!).
*    25. Close the authenticator by calling: SST_AuthenticationClose.
*    26. Using session #3 open the AES shared key authenticator by calling:
*            i.   SST_AuthenticatorChallengeGet 
*            ii.  CRYS_AES (Encrypt the challenge using the AES key)
*            iii. SST_AuthenticationOpen.
*    27. Close the transaction by calling: SST_TransactionClose.
*    28. Open a transaction by calling: SST_TransactionStart.
*    29. Modify the data from selected location by calling: SST_ModifyData.
*    30. Close the transaction by calling: SST_TransactionClose.
*    31. Using session #3 open the password authenticator by calling: SST_AuthenticationOpen.
*    32. Open a transaction by calling: SST_TransactionStart.
*    33. Using session #3 bind the password authenticator to the data by calling: SST_BindAuthenticatorToElement. (This should fail!).
*    34. Using session #3 read and compare the modified data by calling: SST_ReadData.
*    35. Using session #3 get the data size and compare to known by calling: SST_GetDataSize.
*    36. Open the public key authenticator with session id#1 by calling:
*           i.   SST_AuthenticatorChallengeGet 
*           ii.  CRYS_RSA_PSS_Sign
*           iii. SST_AuthenticationOpen.
*    37. Close the transaction by calling: SST_TransactionClose.
*    38. Open a transaction by calling: SST_TransactionStart.
*    39. Unbind the data from all other authenticators by calling: SST_AuthenticatorUnbind
*    40. Using session #1 and the master authenticator delete the data by calling: SST_DeleteData.
*    41. Close all of the authenticators (one at a time) by calling: SST_AuthenticationClose.
*    42. Delete all of the authenticators (one at a time) by calling: SST_AuthenticatorDelete.
*    43. Close the transaction by calling: SST_TransactionClose.
*    44. Delete all of the sessions (one at a time) by calling: SST_SessionDelete.
*******************************************************************************/
DxError_t SEPQA_SST_BindingWritingPermissions ( void );



#ifdef __cplusplus
}


#endif

#endif

